use num::Complex;
use std::f32::consts::PI;

const N: usize = 100;
const FS: f32 = 50.0;
const F: f32 = 3.0;
const A: f32 = 7.0;

fn main() {
    let mut osc = Complex::new(A, 0.0);
    let delta = Complex::cis(2.0 * PI * F / FS);
    let s: Vec<Complex<f32>> = std::iter::from_fn(move || {
        let ss = osc;
        osc *= delta;
        Some(ss)
    })
    .take(N)
    .collect();

    let max = s.iter().fold(f32::MIN, |m, x| m.max(x.re.max(x.im)));
    let min = s.iter().fold(f32::MAX, |m, x| m.min(x.re.min(x.im)));
    println!("min: {}, max: {}", min, max);
}
