use gnuplot::{Caption, Figure};
use num::Complex;
use std::f32::consts::PI;

const N: usize = 100;
const FS: f32 = 50.0;
const F: f32 = 3.0;
const A: f32 = 7.0;

fn main() {
    let mut osc = Complex::from_polar(A, PI / 8.0);
    let increment = Complex::cis(2.0 * PI * F / FS);
    let s: Vec<Complex<f32>> = std::iter::from_fn(move || {
        let ss = osc;
        osc *= increment;
        Some(ss)
    })
    .take(N)
    .collect();

    let s_real: Vec<f32> = s.iter().map(|x| x.re).collect();
    let s_imag: Vec<f32> = s.iter().map(|x| x.im).collect();

    let t: Vec<f32> = (0..N).map(|t| t as f32 / FS).collect();

    let mut fg = Figure::new();
    fg.axes2d()
        .lines(&t, &s_real, &[Caption("cos(2πft)")])
        .lines(&t, &s_imag, &[Caption("sin(2πft)")]);
    fg.show().unwrap();
}
