use gnuplot::{Caption, Figure};
use num::Complex;
use std::f32::consts::PI;

const N: usize = 100;
const FS: f32 = 50.0;
const F: f32 = 3.0;
const A: f32 = 7.0;

fn main() {
    let s: Vec<Complex<f32>> = (0..N)
        .map(|t| A * (2.0 * PI * F * t as f32 / FS).cos())
        .map(|ss| Complex::new(ss, 0.0))
        .collect();

    let s_real: Vec<f32> = s.iter().map(|x| x.re).collect();
    let s_imag: Vec<f32> = s.iter().map(|x| x.im).collect();

    let t: Vec<f32> = (0..N).map(|t| t as f32 / FS).collect();

    let mut fg = Figure::new();
    fg.axes2d()
        .lines(&t, &s_real, &[Caption("cos(2πft)")])
        .lines(&t, &s_imag, &[Caption("zero")]);
    fg.show().unwrap();
}
