use gnuplot::{Caption, Figure};
use std::f32::consts::PI;

const N: usize = 100;
const FS: f32 = 50.0;
const F: f32 = 3.0;
const A: f32 = 7.0;

fn main() {
    let mut theta: f32 = 0.0;
    let s: Vec<f32> = std::iter::from_fn(move || {
        let ss = theta.cos();
        theta += 2.0 * PI * F / FS;
        theta %= 2.0 * PI;
        Some(A * ss)
    })
    .take(N)
    .collect();

    let t: Vec<f32> = (0..N).map(|t| t as f32 / FS).collect();

    let mut fg = Figure::new();
    fg.axes2d().lines(&t, &s, &[Caption("cos(2πft)")]);
    fg.show().unwrap();
}
